﻿<?php

require_once('engine/modules/mcserveris/mcconfig.php');
require_once('engine/modules/mcserveris/MinecraftQuery.class.php');

$query = new MinecraftQuery();
try {
	$query->Connect(MQ_SERVER_ADDR, MQ_SERVER_PORT, MQ_TIMEOUT);
} catch (MinecraftQueryException $e) {
	$error = $e->getMessage();
}

?>

<?php if (isset($error)): ?>
		<div class="error"><?php echo htmlspecialchars($error) ?></div>
<?php else: 

?>
		<table class="mcinfo">
			<tr>
				<th colspan="2">
				
				 Minecraft</th>
			</tr>
<?php if (($info = $query->GetInfo()) !== false): ?>
<?php foreach ($info as $info_key => $info_value): 
?>
			<tr>
				<th><?php echo htmlspecialchars($info_key) ?></th>
				<td><?php echo htmlspecialchars($info_value) ?></td>
			</tr>
<?php endforeach ?>
<?php endif ?>
		</table>
		<br clear='all' />
		<table class="players">
			<tr>
				<th></th>
			</tr>
<?php if (($players = $query->GetPlayers()) !== false): ?>
<?php foreach ($players as $player): ?>
			<tr>
				<td><?php echo htmlspecialchars($player) ?></td>
			</tr>
<?php endforeach ?>
<?php endif ?>
		</table>
		<br clear='all' />
<?php endif ?>
